<?php

use app\models\Accounts;
use app\models\Bills;
use app\models\Rfq;
use app\models\Services;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Rfqcontent */

$this->title = 'Request for quotation form';
$this->params['breadcrumbs'][] = ['label' => 'Rfqcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rfqcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
     <p align="left">
        <?= Html::a('', ['rfqcontent/printrequestforquote','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
           <p align="right">
        <?= Html::button('New service/product',['value'=>\yii\helpers\Url::toRoute('services/create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
    </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
    

<p><b>Rfq #:</b> <?php echo $id; ?></br> <b>Rfq by:</b><?php echo Rfq::findOne($id)->billby0->name; ?></br> <b>Currency:</b><?php echo Bills::getPaytype(Rfq::findOne($id)->paytype).'-'.Accounts::getCurrency(Rfq::findOne($id)->currency); ?>
</br><b> Billed on: </b><?php echo date('d-m-Y',strtotime(Rfq::findOne($id)->date));?></br><b>Due date:</b><?php echo date('d-m-Y',strtotime(Rfq::findOne($id)->dueDate));?> </p>

  <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            
            [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId; }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],     
            
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['rfqcontent/update','id'=>$model->id],[
                    'class' => 'glyphicon glyphicon-edit',
                ]);
                },
                ],
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

    <?= $this->render('_form', [
        'model' => $model,'c'=>Rfq::findOne($id)->currency,
    ]) ?>

</div>
