<?php 
use app\models\Cars;
use app\models\Cartype;
use app\models\Dispatchcontents;
use app\models\Wstoredispatch;
use yii\helpers\Html;
use app\models\Billcontent;

?>

<table width="100%">
<tr>
<td width="30%" align="center">
<?php if(\Yii::$app->session->get('company')==1){ echo Html::img("img/itl.jpg"); }elseif (\Yii::$app->session->get('company')==2){ echo Html::img("img/imsl.jpg"); } ?> 
</td>
</tr></table>

<?php 
?>


<h3 align="center">Truck spare utilization report from <?php echo $from; ?> to <?php echo $to; ?></h3>

</br>

<?php 
$f=date('Y-m-d',strtotime($from));
$t=date('Y-m-d',strtotime($to));

$trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])->orderBy(['typeId'=>SORT_DESC])->all();
$informations=array();
$infoaverage=array();
$dcontents=array();
$cnt=0;
$ttl=0;


if ($trucks != null){
    foreach ($trucks as $truck){
        $total=0;
        $informations[$cnt]['truck']=$truck->plateno;
        
        $dispatches= Wstoredispatch::getCarDispatchesByTime($truck->plateno,$f,$t);
        if ($dispatches != null){
            foreach ($dispatches as $dispatch){
                $contents= Dispatchcontents::find()->where(['dispatchId'=>$dispatch->id])->all();
                if ($contents != null){
                    foreach ($contents as $content){
                        $price=Billcontent::checkServiceAmountInBill($content->store->serviceId,$content->store->billId);
                        if ($price != null) { $total=$total+ $price*$content->quantity; }
                    }
                }
                
            }
        }
        
        $informations[$cnt]['total']=$total;
        $infoaverage[$cnt]['total']=$total;
        $ttl=$ttl+$total;
        $cnt++;
    }
    
    if ($informations != null and $infoaverage != null){ array_multisort($infoaverage,SORT_DESC,$informations); }
}

?>

<h5>Total spare cost: <?php echo number_format($ttl); ?></h5>

<table class="table table-striped table-bordered table-hover">
<tr><th>#</th><th>Trucks</th><th width="470px">Spares</th><th>Sub total</th></tr>

<?php for ($i=0; $i<count($informations); $i++){ ?>

<tr><td><?php echo $i+1; ?></td><td><?php echo $informations[$i]['truck']; ?></td><td>

<?php 
$dispatches= Wstoredispatch::getCarDispatchesByTime($informations[$i]['truck'],$f,$t);
if ($dispatches != null){
    foreach ($dispatches as $dispatch){
        $contents= Dispatchcontents::find()->where(['dispatchId'=>$dispatch->id])->all();
        if ($contents != null){
            foreach ($contents as $content){
                $price=Billcontent::checkServiceAmountInBill($content->store->serviceId,$content->store->billId);
                echo $content->quantity.'-'.$content->store->service->name.' @ '. number_format($price).' on '.date("d-m-Y",strtotime($dispatch->date)).'<br />';
            }
        }
    }
}

?>
</td><td><?php echo number_format($informations[$i]['total']); ?></td> </tr>
<?php } ?>

</table>


