<?php

use app\models\Dispatchcontents;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WstoreSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Workshop store';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wstore-index">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
         <?= Html::button('New stock',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
    <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return $model->service->name; }
            ],
            'billId',
            [
                'attribute'=>'quantity',
                'value'=>function ($model, $key, $index, $widget) {return Dispatchcontents::getStoreBalance($model->id); }
            ],
            //'byy',
            //'onn',
            //'status',

            [
                'class' => 'yii\grid\ActionColumn',
                'template'=>'{update}',
            ],
        ],
    ]); ?>
</div>
