<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Trafficoffences;
use app\models\Uzers;
use app\models\Cardrivers;
use Faker\Provider\cs_CZ\DateTime;

/* @var $this yii\web\View */
/* @var $searchModel app\models\TrafficoffencesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Active traffic offences';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="trafficoffences-index">

     <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::button('New offence',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
     <p align="left">
        <?= Html::a('', ['printoffences'], ['class' => 'glyphicon glyphicon-download-alt']) ?>
    </p>
    
   
    
<?php 

    Modal::begin([
        'options'=>[
            'tabindex' => false,
        ],
        'header'=>'',
        'id'=>'modal',
        'size'=>'modal-lg',
    ]);
    
    echo '<div id="modalContent"></div>';
    
    Modal::end();
    
    ?>
   

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'ref',
            [
                'attribute'=>'responsible',
                'value'=>function ($model, $key, $index, $widget) {
                  return Trafficoffences::getResponsible($model->responsible);
                },
                ],
                
                [
                    'attribute'=>'driverId',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Cardrivers::findOne($model->driverId)->user->fullName;
                    },
                    ],
                    
            'carId',
            [
                'attribute'=>'Amount',
                'value'=>function ($model, $key, $index, $widget) {
                return Trafficoffences::calculateCost($model->offencedate,$model->paiddate,$model->Amount);
                },
                ],
                
                [
                    'attribute'=>'offencedate',
                    'value'=>function ($model, $key, $index, $widget) {
                    return date('d-m-Y',strtotime($model->offencedate));
                    },
                    ],
            //'location',
            //'officer',
            //'reason',
            //'paiddate',
            //,

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
