<?php

use app\models\Cars;
use app\models\Cartype;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Statistics;

/* @var $this yii\web\View */
/* @var $searchModel app\models\StatisticsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = "Today's statistics";
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="statistics-index">

  
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

       <p align="right">
        <?= Html::button('New statistics',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
      <h3><?= Html::encode($this->title) ?></h3>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>


<table class="table table-striped table-bordered table-hover">
<?php 
$trucks= Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
$total=0;
$c=1;
if ($trucks != null){
    foreach ($trucks as $truck){
        $stats= Statistics::getTruckTodayStatistics($truck->plateno);
        $tot=0;
        if ($stats != null){
            ?>
            <tr><td><?php echo $c; ?></td></td><td><?php echo $truck->plateno; ?></td><td>
            <?php 
            foreach ($stats as $stat){
                ?>
                <b><?php echo $stat->movetype0->name;?></b> | <?php echo $stat->driver0->user->fullName; ?>   | <?php if ($stat->size !=0) echo $stat->quantity.' - '.$stat->size.'0 ft'; else echo 'Others'; ?>  | <?php echo number_format($stat->quantity*Statistics::getExpectedIncome($stat->movetype,$stat->size)).' Usd'; ?> 
		<?php $tot=$tot+Statistics::getExpectedIncome($stat->movetype,$stat->size)*$stat->quantity; ?><br /> <?php }  ?> </td>
		<td align="right"><?php  $total=$total+$tot; echo number_format($tot,2).' Usd'; ?></td></tr>
                <?php 
                $c++;
            }
        }
    }

?>
</table>
</div>
