<?php

use app\models\Cardrivers;
use app\models\Cars;
use app\models\Cartype;
use app\models\Clients;
use app\models\Movetype;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Statistics */
/* @var $form yii\widgets\ActiveForm */
?>

<?php  	

$driver = ArrayHelper:: map (Cardrivers::find()->where(['status'=>1])-> all() , 'id' , function($model, $defaultValue){ return $model['user']['firstname'].' '.$model['user']['lastname']; }); 
$client = ArrayHelper:: map (Clients::find()->where(['type'=>1])->all() , 'id' , 'name');
$truck = ArrayHelper:: map (Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1])-> all() , 'plateno' , 'plateno');
$moves = ArrayHelper:: map (Movetype::find()-> all() , 'id' , function($model, $defaultValue){ return $model['name'].' ('.Movetype::getTripType($model['triptype']).')'; });
$shippingline = ArrayHelper:: map (Clients::find()->where(['type'=>2])->all() , 'id' , 'name');

?>


<div class="statistics-form">

     <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table width="100%">
<tr>

 <td>
  <?php 
echo $form->field($model, 'movetype')->widget(Select2::classname(), [
    'data' => $moves,
    'language' => 'en',
    'options' => ['placeholder' => 'Select a movement type...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
?>
</td>

 <td> <?= $form->field($model, 'size')->dropdownList([
        2 => '20ft', 
        4 => '40ft',
         0=>'Nill',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

<td> <?= $form->field($model, 'quantity')->textInput() ?> </td>

<td>
 <?php 

echo $form->field($model, 'driver')->widget(Select2::classname(), [
    'data' => $driver,
    'language' => 'en',
    'options' => ['placeholder' => 'Select a driver...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);

?>
</td>

<td>

   <?php 

echo $form->field($model, 'truckId')->widget(Select2::classname(), [
    'data' => $truck,
    'language' => 'en',
    'options' => ['placeholder' => 'Select truck...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);

?>
</td>

<td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'date',
    'options' => ['placeholder' => 'Date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>

</tr>

<tr>
<td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    
    </td> <td></td> <td></td><td></td> </tr>
    
    </table>

    <?php ActiveForm::end(); ?>

</div>
