<?php

use app\models\Overtime;
use app\models\Salaries;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\OvertimeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = date('M',strtotime($reqdate)).' Overtimes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="overtime-index">

    <p align="right">
        <?= Html::button('Register overtime',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
    <h3><?= Html::encode($this->title) ?></h3>

</div>


<?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
    
     <table class="table table-striped table-bordered table-hover">
                              <thead>
                                 <tr>
                                    <th>#</th>
                                    <th>Employee</th>
                                    <th>Salary</th>
                                    <th>Overtime</th>
                                    <th>Reason</th>
                                 
                                 </tr>
                              </thead>
                              <tbody>
                              <?php
                              $cnt=1;
                              if ($users != null){
                              foreach ($users as $user){ 
                                  $overtime=Overtime::getUserOvertime($user->id);
                                  if ($overtime != null){
                                  ?>
                              <tr>
                              <td><?php echo $cnt; ?></td>
                              <td><?php echo $user->fullName; ?></td>
                              <td><?php echo number_format(Salaries::getUserSalary($user->id)->amount,2);  ?></td>
                              <td><?php echo $overtime != null? number_format($overtime->amount,2):'Not set';  ?></td>
                              <td><?php echo $overtime->reason;  ?></td>
                              </tr>
                              <?php $cnt++; } } }?>
                              </tbody>
                              </table>

</div>
