<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Movetype;
use Symfony\Component\Finder\Comparator\DateComparator;

/* @var $this yii\web\View */
/* @var $searchModel app\models\MovementsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All movements';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="movements-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New movement', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    
    
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'containerno',
            
            [
                'attribute'=>'truckId',
                'value'=>function ($model, $key, $index, $widget) {return $model->truck->plateno; }
            ],
            
            
            [
                'attribute'=>'interchangedate',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->interchangedate)); },
                ],
            
            [
                'attribute'=>'clientId',
                'value'=>function ($model, $key, $index, $widget) {return $model->client->name; },
                ],
            
            [
                'attribute'=>'movetypeId',
                'value'=>function ($model, $key, $index, $widget) {return $model->movetype->name; },
            ],
           
            [
                'attribute'=>'size',
                'value'=>function ($model, $key, $index, $widget) {return  Movetype::getContainerSize($model->size); }
            ],
            [
                'attribute'=>'shippingline',
                'value'=>function ($model, $key, $index, $widget) {return  $model->shippingline0->name; }
            ],
           
            [
                'attribute'=>'driverId',
                'value'=>function ($model, $key, $index, $widget) {return $model->driver->user->firstname.' '.$model->driver->user->lastname;},
            ],
           
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}',
            ],
        ],
    ]); ?>
</div>

<?php /*
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();
*/
?>
