<?php

use app\models\Movetype;
use yii\grid\GridView;
use yii\helpers\Html;
use yii\data\ArrayDataProvider;
use app\models\Cardrivers;

/* @var $this yii\web\View */
/* @var $model app\models\Movements */

$this->title = 'Driver container list:'. Cardrivers::findOne($driverId)->user->fullName;
$this->params['breadcrumbs'][] = ['label' => 'Movements', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

        <p align="right">
        <?= Html::a('', ['movements/printdrivercontainerlist','from'=>$from,'to'=>$to,'driverId'=>$driverId], ['class' => 'glyphicon glyphicon-download-alt']) ?>
    </p>


 <h3><?= Html::encode($this->title) ?></h3>
 
  <table class="table table-striped table-bordered table-hover">
                              <thead>
                                 <tr>
                                 <th>#</th>
                                    <th>Container #</th>
                                     <th>Size</th>
                                    <th>Movement type</th>
                                    <th>Date</th>
                                 </tr>
                              </thead>
                              <tbody>
               
               <?php if ($containers !=null){ 
                            $cnt=1;
                   foreach ($containers as $container){
                       ?>
                        <tr>
                                 <th><?php echo $cnt; ?></th>
                                    <th><?php echo $container->containerno; ?></th>
                                     <th><?php echo Movetype::getContainerSize($container->size); ?></th>
                                    <th><?php echo Movetype::findOne($container->movetypeId)->name; ?></th>
                                    <th><?php echo date('d-m-Y',strtotime($container->interchangedate)); ?></th>
                                 </tr>
                       <?php 
                       $cnt++;
                   }
                }

                ?>
                </tbody></table>