<?php

use app\models\Movetype;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Movements */

$this->title = 'Client movements by date';
$this->params['breadcrumbs'][] = ['label' => 'Movements', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="movements-create">

    <h3><?= Html::encode($this->title) ?></h3>

    <?= $this->render('_dateclientform', [
        'model' => $model,
    ]) ?>

</div>

<?php if ($client != null){ ?><h4>CLIENT: <?php echo strtoupper(\app\models\Clients::findOne($client)->name); ?> | NUMBER OF MOVEMENTS: <?php echo $dataProvider->getCount(); }?></h4>


 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'containerno',
            
            [
                'attribute'=>'truckId',
                'value'=>function ($model, $key, $index, $widget) {return $model->truck->plateno; }
            ],
            
            
            [
                'attribute'=>'interchangedate',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->interchangedate)); },
                ],
            
            [
                'attribute'=>'clientId',
                'value'=>function ($model, $key, $index, $widget) {return $model->client->name; },
                ],
            
            [
                'attribute'=>'movetypeId',
                'value'=>function ($model, $key, $index, $widget) {return $model->movetype->name; },
            ],
           
            [
                'attribute'=>'size',
                'value'=>function ($model, $key, $index, $widget) {return  Movetype::getContainerSize($model->size); }
            ],
            [
                'attribute'=>'shippingline',
                'value'=>function ($model, $key, $index, $widget) {return  $model->shippingline0->name; }
            ],
           
            [
                'attribute'=>'driverId',
                'value'=>function ($model, $key, $index, $widget) {return $model->driver->user->firstname.' '.$model->driver->user->lastname;},
            ],
           
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}',
            ],
        ],
    ]); ?>
</div>

