<?php

use app\models\Accounts;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Invoices;
use app\models\Invcontent;
use app\models\Invopayments;

/* @var $this yii\web\View */
/* @var $searchModel app\models\InvoicesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Invoice summary by Account from: '.$from.' to: '.$to;
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="invoices-index">

   
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
      
      
    <?= $this->render('_clientsummary', [
        'model' => $model,
    ]) ?>
    
     <h3><?= Html::encode($this->title) ?></h3>

<?php if ($dataProvider != null){ ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'accId',
                'value'=>function ($model, $key, $index, $widget) {return $model->acc->name.'-'.Accounts::getCurrency($model->acc->currency); }
          
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'type',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::getInvoiceType($model->type); },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->type==1){
                    return ['style' =>'background-color:#197777; color:white;'];
                }elseif ($model->type==2){
                    return ['style' =>'background-color:#101CE0; color:white;']; 
                }elseif ($model->type==3){
                    return ['style' =>'background-color:#383FAF; color:white;']; 
                }
                },
            ],
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id)); }
            ],
            [
                'attribute'=>'paida',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invopayments::getInvoicePaidAmount($model->id)); }
            ],
            
            [
                'attribute'=>'balance',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id)-Invopayments::getInvoicePaidAmount($model->id)); }
            ],
            //'company',
            //'type',
            //'tax',
            //'currency',

                [
                    'label'=>' ',
                    'format' => 'raw',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Html::a('',['invcontent/printinvoice','id'=>$model->id],['class' => 'glyphicon glyphicon-download-alt']);
                    },
                    ],

        ],
    ]); ?>
    
    <?php } ?>
    
</div>
