<?php

use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Accounts;
use app\models\Invoices;
use app\models\Services;

/* @var $this yii\web\View */
/* @var $model app\models\Invcontent */

$this->title = Invoices::getInvoiceType(Invoices::findOne($id)->type);
$this->params['breadcrumbs'][] = ['label' => 'Invoices', 'url' => ['invoices/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="invcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="right">
        <?= Html::a('', ['invcontent/printinvoice','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
    </p>

<h4>Invoice #: <?php echo Invoices::getInvoiceNo(Invoices::findOne($id)->type,$id); ?></br> Invoice to:<?php echo Invoices::findOne($id)->acc->name.'-'.Accounts::getCurrency(Invoices::findOne($id)->acc->currency); ?> </br>Date: <?php echo date('d-m-Y',strtotime(Invoices::findOne($id)->date));?> </h4>

 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name.'-'.Accounts::getCurrency(Accounts::findOne(Services::findOne($model->serviceId)->saleaccId)->currency); }
            ],
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],
            
            [
                'attribute'=>'subtotal',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count*$model->amount); }
            ],
            
            [
                'attribute'=>'tax',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format($model->count*$model->amount*0.18):0; }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format(($model->count*$model->amount)+($model->count*$model->amount*0.18)):number_format($model->count*$model->amount); }
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>


<?php if (Invoices::findOne($id)->fileId==0) { ?>

    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>
    
<?php } else{ ?>
    
        <?= $this->render('_cnform', [
            'model' => $model,'id'=>$id,
    ]) ?>
    
<?php } ?>
</div>
