<?php

use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Wstore;
use app\models\Wstoredispatch;

/* @var $this yii\web\View */
/* @var $model app\models\Dispatchcontents */

$this->title = 'Dispatch contents';
$this->params['breadcrumbs'][] = ['label' => 'Dispatchcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="dispatchcontents-create">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
    
<h4>Dispatch #: <?php echo $id; ?></br> Requested by:<?php echo Wstoredispatch::findOne($id)->byy; ?> </br> Requested on: <?php echo date('d-m-Y',strtotime(Wstoredispatch::findOne($id)->date));?></br>For car #: <?php echo Wstoredispatch::findOne($id)->truckId;?> </h4>
    
    
     <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'storeId',
                'value'=>function ($model, $key, $index, $widget) {return Wstore::findOne($model->storeId)->service->name; }
            ],
            [
                'attribute'=>'quantity',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->quantity); }
            ],
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
