<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Accounts;
use app\models\Billcontent;
use app\models\Bills;

/* @var $this yii\web\View */
/* @var $searchModel app\models\BillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All pending bills';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="bills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

     <p align="right">
        <?= Html::a('New bill', ['create'], ['class' => 'btn btn-success']) ?>
      </p>
    
        <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'billby',
                'value'=>function ($model, $key, $index, $widget) {return $model->billby0->name.'-'.Accounts::getCurrency($model->billby0->currency); }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->dueDate)); }
            ],
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->id)).'-'.Accounts::getCurrency($model->billby0->currency); }
            ],
            //'paid',
            //'company',
            //'currency',
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['billcontent/create','id'=>$model->id],['class' => 'glyphicon glyphicon-tasks']);
                },
                ],
                
                [
                    'label'=>' ',
                    'format' => 'raw',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Html::a('',['billcontent/printrequest','id'=>$model->id],['class' => 'glyphicon glyphicon-download-alt']);
                    },
                    ],
                    
                    [
                        'label'=>' ',
                        'format' => 'raw',
                        'value'=>function ($model, $key, $index, $widget) {
                        return Html::a('',['billpayments/create','id'=>$model->id],['class' => 'glyphicon glyphicon-check']);
                        },
                        ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
</div>
