<?php

use app\models\Accounts;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Billpayments */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $expAccounts = ArrayHelper:: map (Accounts::find()->where(['type'=>Accounts::getAccountsByCategory([4,1])])->all() , 'id' , function($model, $defaultValue){ return $model->name.'-'.Accounts::getCurrency($model->currency); }); ?>

<div class="billpayments-form">

      <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
    <table width="100%">
<tr>

 <td>
         <?php 

echo $form->field($model, 'accountId')->widget(Select2::classname(), [
    'data' => $expAccounts,
    'language' => 'en',
    'options' => ['placeholder' => 'Payment account...',],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
</td>

<td>
    <?= $form->field($model, 'amount')->textInput(['maxlength' => true]) ?>
</td>

<td>
    <?= $form->field($model, 'checkNo')->textInput(['maxlength' => true]) ?>
</td>

</tr></table>
  
  <table>
  <tr>
  <td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td>
    </tr>
 </table>
    <?php ActiveForm::end(); ?>

</div>
