<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "trucks".
 *
 * @property string $id
 * @property string $registeredDate
 * @property int $driverId
 * @property string $chassisNo
 * @property string $engineNo
 * @property string $modelNo
 * @property int $cat
 * @property int $status
 * @property int $company
 */
class Trucks extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'trucks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'chassisNo', 'engineNo', 'modelNo'], 'required'],
            [['registeredDate'], 'safe'],
            [['driverId', 'cat', 'status', 'company'], 'integer'],
            [['id'], 'string', 'max' => 16],
            [['chassisNo', 'engineNo', 'modelNo'], 'string', 'max' => 30],
            [['id'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'registeredDate' => 'Registered Date',
            'driverId' => 'Driver ID',
            'chassisNo' => 'Chassis No',
            'engineNo' => 'Engine No',
            'modelNo' => 'Model No',
            'cat' => 'Cat',
            'status' => 'Status',
            'company' => 'Company',
        ];
    }
}
