<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Trafficoffences;
use phpDocumentor\Reflection\Types\Null_;

/**
 * TrafficoffencesSearch represents the model behind the search form of `app\models\Trafficoffences`.
 */
class TrafficoffencesSearch extends Trafficoffences
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'responsible', 'driverId', 'Amount'], 'integer'],
            [['ref', 'location', 'offencedate'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Trafficoffences::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'responsible' => $this->responsible,
            'driverId' => $this->driverId,
            'Amount' => $this->Amount,
            'paiddate' =>'0000-00-00',
            'offencedate' => $this->offencedate,
            'company'=>\Yii::$app->session->get('company'),
        ]);

        $query->andFilterWhere(['like', 'carId', $this->carId])
            ->andFilterWhere(['like', 'ref', $this->ref])
            ->andFilterWhere(['like', 'location', $this->location])
            ->andFilterWhere(['like', 'officer', $this->officer])
            ->andFilterWhere(['like', 'reason', $this->reason]);

        return $dataProvider;
    }
}
