<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "services".
 *
 * @property int $id
 * @property string $name
 * @property string $description
 * @property int $company
 * @property int $status
 * @property string $date
 * @property int $saleaccId
 * @property int $purchaseaccId
 *
 * @property Servicecost[] $servicecosts
 */
class Services extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $purchasecost, $saleprice;
    public static function tableName()
    {
        return 'services';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'description', 'company', 'date'], 'required'],
            [['company', 'status', 'saleaccId', 'purchaseaccId'], 'integer'],
            [['date'], 'safe'],
            [['name'], 'string', 'max' => 50],
            [['description'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'description' => 'Description',
            'company' => 'Company',
            'status' => 'Status',
            'date' => 'Date',
            'saleaccId' => 'Sale acc',
            'purchaseaccId' => 'Purchase acc',
            'purchasecost'=>'Purchase cost',
            'saleprice'=>'Sale price',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getServicecosts()
    {
        return $this->hasMany(Servicecost::className(), ['serviceId' => 'id']);
    }
    
    public function getServiceByName($name){
        
        $services= Services::find()->where(['like', 'name' , $name])->orderBy(['id'=>SORT_DESC])->all();
        $return=null;
        
        if ($services != null){
            foreach ($services as $service){
                if ($service->saleaccId != null){
                    if (Accounts::findOne($service->saleaccId)->currency==1){
                    $return=$service;
                    break;
                    }
                }
            }
        }
        
        return $return;
    }
    

}
