<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "overtime".
 *
 * @property int $id
 * @property int $userId
 * @property string $amount
 * @property string $reason
 * @property string $date
 *
 * @property Uzers $user
 */
class Overtime extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'overtime';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId', 'amount', 'reason', 'date'], 'required'],
            [['userId'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['reason'], 'string', 'max' => 100],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'User ID',
            'amount' => 'Amount',
            'reason' => 'Reason',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getUserOvertime($id){
        $ret=null;
        $overtime= Overtime::find()->where(['userId'=>$id])->orderBy('id Desc')->all();
        
        if ($overtime != null){
            foreach ($overtime as $sala){
                $ret=$sala;
                break;
            }
        }
        
        return $ret;
    }
    
    public function checkDublicate($id,$amount){
        $ret=null;
        $from=date('Y').'-'.date('m').'-1';
        $to=date('Y-m-d');
        $overtime= Overtime::find()->where("date >= '$from' and date <= '$to'",['userId'=>$id,'amount'=>$amount])->orderBy('id Desc')->all();
        
        if ($overtime != null){
            foreach ($overtime as $time){
                $ret=$time;
            }
        }
        return $ret;
    }
}
