<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "movetype".
 *
 * @property int $id
 * @property string $name
 * @property int $triptype
 * @property string $incentive
 * @property string $twentypay
 * @property string $fortypay
 * @property string $otherpay
 *
 * @property Movefuelratio[] $movefuelratios
 */
class Movetype extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $ratios; 
    
    public static function tableName()
    {
        return 'movetype';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'incentive', 'twentypay', 'fortypay', 'otherpay'], 'required'],
            [['triptype','currency'], 'integer'],
            [['incentive', 'twentypay', 'fortypay', 'otherpay'], 'number'],
            [['name'], 'string', 'max' => 45],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Movement name',
            'triptype' => 'type of trip',
            'incentive' => 'Incentive(Tsh)',
            'twentypay' => 'Charges(20ft)',
            'fortypay' => 'Charges(40ft)',
            'otherpay' => 'Charges(Other)',
            'ratios'=>'Ratios',
            'currency'=>'Charges currency',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMovefuelratios()
    {
        return $this->hasMany(Movefuelratio::className(), ['movetypeId' => 'id']);
    }
    
    public function getTripType($id){
        if ($id==1) return 'Full trip';
        elseif ($id==2) return 'Empty trip';
        else return 'Other trip';
    }
    
    public function getContainerSize($id){
        if ($id==2) return '20ft';
        elseif ($id==4) return '40ft';
        else return 'Nill'; 
    }
    
    public function driverIncentiveByTime($id,$from,$to){
        
        $total=0;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("registereddate >= '$from' and registereddate <= '$to' and driverId='$id' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=1){
                            $trp=$trp+1;
                        }elseif ($movement->movetype->triptype==1 and $movement->size!=2){
                            $trp=$trp+1;
                        }
                    }
                }
                $total=$total+$trp*$movetype->incentive;
            }
        }
        
        return $total;
    }
    
    
    public function carIncentiveByTime($id,$from,$to){
        
        $total=0;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("registereddate >= '$from' and registereddate <= '$to' and truckId='$id' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=1){
                            $trp=$trp+1;
                        }elseif ($movement->movetype->triptype==1 and $movement->size!=2){
                            $trp=$trp+1;
                        }
                    }
                }
                $total=$total+$trp* $movetype->incentive;
            }
        }
        
        return $total;
    }
   
    
}
