<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "movefuelratio".
 *
 * @property int $id
 * @property int $cartypeId
 * @property int $movetypeId
 * @property int $tankcapacity
 * @property int $moveconsumption
 *
 * @property Cartype $cartype
 * @property Movetype $movetype
 */
class Movefuelratio extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'movefuelratio';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cartypeId', 'movetypeId', 'moveconsumption'], 'required'],
            [['cartypeId', 'movetypeId'], 'integer'],
            [['cartypeId'], 'exist', 'skipOnError' => true, 'targetClass' => Cartype::className(), 'targetAttribute' => ['cartypeId' => 'id']],
            [['movetypeId'], 'exist', 'skipOnError' => true, 'targetClass' => Movetype::className(), 'targetAttribute' => ['movetypeId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cartypeId' => 'Cartype ID',
            'movetypeId' => 'Movetype ID',
            'moveconsumption' => 'Moveconsumption',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCartype()
    {
        return $this->hasOne(Cartype::className(), ['id' => 'cartypeId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMovetype()
    {
        return $this->hasOne(Movetype::className(), ['id' => 'movetypeId']);
    }
    
    public function getConsumedFuel($moveId, $cartype){
        $csm=0;
        
        $consumed= Movefuelratio::find()->where(['movetypeId'=>$moveId,'cartypeId'=>$cartype])->one();
        
        if($consumed != null) $cms=$consumed->moveconsumption;
        
        return $cms;
    }
}
