<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invopayments".
 *
 * @property int $id
 * @property int $invId
 * @property string $date
 * @property int $userId
 * @property int $acId
 * @property string $checkNo
 * @property string $amount
 * @property int $company
 *
 * @property Uzers $user
 * @property Accounts $ac
 * @property Invoices $inv
 */
class Invopayments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invopayments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['invId', 'date', 'userId', 'acId', 'checkNo', 'amount'], 'required'],
            [['invId', 'userId', 'acId', 'company'], 'integer'],
            [['date'], 'safe'],
            [['amount'], 'number'],
            [['checkNo'], 'string', 'max' => 30],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
            [['acId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['acId' => 'id']],
            [['invId'], 'exist', 'skipOnError' => true, 'targetClass' => Invoices::className(), 'targetAttribute' => ['invId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invId' => 'Inv ID',
            'date' => 'Date',
            'userId' => 'User ID',
            'acId' => 'Paid acc',
            'checkNo' => 'Check No',
            'amount' => 'Amount',
            'company' => 'Company',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAc()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'acId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInv()
    {
        return $this->hasOne(Invoices::className(), ['id' => 'invId']);
    }
    
    public function getInvoicePaidAmount($id){
        $ret=0;
        
        $payments=Invopayments::find()->where(['invId'=>$id])->all();
        
        if ($payments != null){
            foreach ($payments as $payment){
                $ret=$ret+$payment->amount;
            }
        }
        
        return $ret;
    }
}
