<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "docsupload".
 *
 * @property int $id
 * @property int $docsId
 * @property int $fileId
 * @property string $name
 * @property string $onn
 * @property int $byy
 *
 * @property Uzers $byy0
 * @property Cfile $file
 */
class Docsupload extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $file;
    
    public static function tableName()
    {
        return 'docsupload';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['docsId', 'fileId', 'name', 'onn','reqdate','recdate','byy'], 'required'],
            [['docsId', 'fileId', 'byy'], 'integer'],
            [['onn'], 'safe'],
            [['file'],'file'],
            [['name'], 'string', 'max' => 100],
            [['byy'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['byy' => 'id']],
            [['fileId'], 'exist', 'skipOnError' => true, 'targetClass' => Cfile::className(), 'targetAttribute' => ['fileId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'docsId' => 'Docs ID',
            'fileId' => 'File ID',
            'name' => 'Name',
            'onn' => 'Onn',
            'byy' => 'Byy',
            'file'=>'Attachment doc',
            'reqdate'=>'Requested date',
            'recdate'=>'Received date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getByy0()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'byy']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFile()
    {
        return $this->hasOne(Cfile::className(), ['id' => 'fileId']);
    }
    
    public function getDocumentById($id){
        
        $docs= Docsupload::find()->where(['fileId'=>\Yii::$app->session->get('fileId'),'docsId'=>$id])->orderBy('id DESC')->all();
        $ret=null;
        if ($docs != null){
            foreach ($docs as $doc){
                $ret=$doc;
                break;
            }
        }
        
        return $ret;
    }
}
