<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "deductions".
 *
 * @property int $id
 * @property int $salaryId
 * @property string $amount
 * @property string $reason
 *
 * @property Salaries $salary
 */
class Deductions extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'deductions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['salaryId', 'amount', 'reason'], 'required'],
            [['salaryId'], 'integer'],
            [['amount'], 'number'],
            [['reason'], 'string', 'max' => 100],
            [['salaryId'], 'exist', 'skipOnError' => true, 'targetClass' => Salaries::className(), 'targetAttribute' => ['salaryId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'salaryId' => 'Salary ID',
            'amount' => 'Amount',
            'reason' => 'Reason',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSalary()
    {
        return $this->hasOne(Salaries::className(), ['id' => 'salaryId']);
    }
}
