<?php

namespace app\models;

use Yii;
use PHPUnit\Framework\Constraint\Count;
use yii\db\conditions\LikeCondition;

/**
 * This is the model class for table "cartype".
 *
 * @property int $id
 * @property string $name
 * @property string $model
 *
 * @property Cars[] $cars
 */
class Cartype extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $numbers,$fulltypename;
    
    public static function tableName()
    {
        return 'cartype';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'model'], 'required'],
            [['name'], 'string', 'max' => 35],
            [['model'], 'string', 'max' => 50],
            ['model', 'unique', 'targetClass' => 'app\models\Cartype', 'message' => 'This model exist'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'model' => 'Model',
            'numbers'=>'Number of cars'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCars()
    {
        return $this->hasMany(Cars::className(), ['typeId' => 'id']);
    }
    
    public function getNumberOfCars($id){
        
        $cars= Cars::find()
       ->where(['typeId'=>$id])->all();
        
       return Count($cars);
    }
    
    public function getFulltypename(){
        
        $tn=$this->name.' '.$this->model;
        
        return $tn;
        
    }
    
    public function getTrailersId(){
        $trailers= Cartype::find()
        ->where([strtolower('name')=>'trailer'])
        ->all();
        
        $trailId=null;
        
        if ($trailers != null){
        foreach ($trailers as $trailer){
         
                $trailId[]=$trailer->id;
            
        }
}
        
        return $trailId;
    }
    
    public function getHorsesId(){
        $trailers= Cartype::find()
        ->where(['NOT LIKE',strtolower('name'),'trailer'])
        ->all();
        
        $trailId=null;
        
        if ($trailers != null){
            foreach ($trailers as $trailer){
                
                $trailId[]=$trailer->id;
                
            }
        }
        
        return $trailId;
    }
    
    public function getCartypeId($name){
        
        $types= Cartype::find()->all();
        
        $ret=9;
        
        if ($types != null){
            foreach ($types as $type){
                $pos1=stripos($name,$type->name);
                $pos2=stripos($name,$type->model);
                if ($pos1!==false){
                    $ret=$type->id;  
                    break;
                }elseif($pos2!==false){
                 $ret=$type->id;   
                 break;
                }
            }
        }
        
        return $ret;
        
    }
}
