<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cardrivers".
 *
 * @property int $id
 * @property int $userId
 * @property string $carId
 * @property int $status
 * @property string $dateassigned
 *
 * @property Cars $car
 * @property Uzers $user
 */
class Cardrivers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cardrivers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId', 'carId', 'dateassigned'], 'required'],
            [['userId', 'status'], 'integer'],
            [['dateassigned'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            [['carId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['carId' => 'plateno']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'Car driver',
            'carId' => 'Car ID',
            'status' => 'Status',
            'dateassigned' => 'Dateassigned',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCar()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'carId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getActiveDriver($id){
        
        $adriver='Non';
        $driver= Cardrivers::find()
        ->where(['carId'=>$id,'status'=>1])
        ->one();
        
        if ($driver != null) $adriver=$driver->user->firstname.' '.$driver->user->lastname;
        
        return $adriver;
        
    }
    
    public function deactivateActiveDriver($hsId,$dId){
        $status= false;
     
        $drivers= Cardrivers::find()
        ->where(['carId'=>$hsId,'status'=>1])
        ->all();
        
        foreach ($drivers as $driver){
            if ($driver->userId != $dId) {
                $driver->status=0;
                $driver->save();
                
                $status=true;
            }
        }
        
        return $status;
    }
    
    public function getDriverStrength($userId){
        
        $drivers= Cardrivers::find()->where(['userId'=>$userId])->all();
        $strength=0;
        
        if ($drivers != null){
            foreach ($drivers as $driver){
                $strength=Movements::driverAllMovements($driver->id);
            }
        }
        return $strength;
    }
}
