<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "billpayments".
 *
 * @property int $id
 * @property int $billId
 * @property string $date
 * @property int $userId
 * @property int $accountId
 * @property string $amount
 * @property string $checkNo
 * @property int $company
 *
 * @property Accounts $account
 * @property Bills $bill
 * @property Uzers $user
 */
class Billpayments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'billpayments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billId', 'date', 'userId', 'accountId', 'amount'], 'required'],
            [['billId', 'userId', 'accountId', 'company'], 'integer'],
            [['date'], 'safe'],
            [['amount'], 'number'],
            [['checkNo'], 'string', 'max' => 10],
            [['accountId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['accountId' => 'id']],
            [['billId'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billId' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billId' => 'Bill ID',
            'date' => 'Date',
            'userId' => 'User ID',
            'accountId' => 'Account ID',
            'amount' => 'Amount',
            'checkNo' => 'Check No',
            'company' => 'Company',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'accountId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getPaidByBill($id){
        $ret=0;
        
        $payments=Billpayments::find()->where(['billId'=>$id])->all();
        
        if ($payments != null){
            foreach ($payments as $payment){
                $ret=$ret+$payment->amount;
            }
        }
        return $ret;
    }
}
