<?php

namespace app\controllers;

use Yii;
use PHPUnit\Util\Json;
use app\models\Trafficoffences;
use app\models\TrafficoffencesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Cars;
use kartik\mpdf\Pdf;

/**
 * TrafficoffencesController implements the CRUD actions for Trafficoffences model.
 */
class TrafficoffencesController extends Controller
{
    public function init() {
        $this->layout = 'operations';
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Trafficoffences models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TrafficoffencesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Trafficoffences model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $model=$this->findModel($id);
        if($model->paiddate=='0000-00-00') $model->paiddate=null;
        
        if ($model->load(Yii::$app->request->post())) {
            $model->paiddate=date('Y-m-d',strtotime($model->paiddate));
            
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved an offence');
                return $this->redirect(['index']);
            }else {
                \Yii::$app->session->setFlash('error','Error on paid date');
                $model=$this->findModel($id);
            }
        }
        
        return $this->render('view', [
            'model' =>$model,
        ]);
    }

    /**
     * Creates a new Trafficoffences model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Trafficoffences();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            $model->company=\Yii::$app->session->get('company');
            $duplicate= Trafficoffences::checkDublicate($model->ref);
            
            if ($duplicate==null){
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved an offence');
            return $this->redirect(['index']);
            }
            }else {
                \Yii::$app->session->setFlash('error','A dublicate offence');
                return $this->redirect(['update', 'id' => $duplicate]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Trafficoffences model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        $model->offencedate=date('d-m-Y',strtotime($model->offencedate));

        if ($model->load(Yii::$app->request->post())) {
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            
            if($model->save()){
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Trafficoffences model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Trafficoffences model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Trafficoffences the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Trafficoffences::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function actionSearchCar($selected)
    {   
        echo json_encode($selected);
    }
    
    public function actionPrintoffences(){
        
        $paid='0000-00-00';
        
        $offences= Trafficoffences::find()
        ->where("paiddate='$paid'")->all();
        
        $data = $this->renderPartial('_printoffence',['offences'=>$offences]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Unpaid traffic offences'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
    public function actionReport(){
        
        $this->layout='main';
        
        $model = new Trafficoffences();
        
        if (isset($_POST['Trafficoffences'])) {
            
            if($_POST['Trafficoffences']['to'] >= $_POST['Trafficoffences']['from']){
                $f=date('Y-m-d',strtotime($_POST['Trafficoffences']['from']));
                $t=date('Y-m-d',strtotime($_POST['Trafficoffences']['to']));
                
            $offences= Trafficoffences::find()->where("offencedate >='$f' and offencedate<='$t'")->all();
        
            $data = $this->renderPartial('_reportview',['offences'=>$offences,'from'=>$_POST['Trafficoffences']['from'],'to'=>$_POST['Trafficoffences']['to']]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Unpaid traffic offences'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
    
}
