<?php

namespace app\controllers;

use Yii;
use app\models\Salaries;
use app\models\SalariesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Uzers;

/**
 * SalariesController implements the CRUD actions for Salaries model.
 */
class SalariesController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Salaries models.
     * @return mixed
     */
    public function actionIndex()
    {
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $reqdate=date('Y-m-d');
        $model = new Salaries();

        if ($model->load(Yii::$app->request->post())) {
            $reqdate=$model->reqdate;
        }
        
        return $this->render('index', [
            'users' => $users,'reqdate'=>$reqdate,
        ]);
    }

    /**
     * Displays a single Salaries model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Salaries model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Salaries();
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();

        if (isset($_POST['Salaries'])) {
            $check=0;
            foreach ($users as $i=>$user){
                if ($_POST['Salaries'][$i]['amount']!=null){
                $model = new Salaries();
                $model->userId=$user->id;
                $model->bankacc=$_POST['Salaries'][$i]['bankacc'];
                $model->ssfacc=$_POST['Salaries'][$i]['ssfacc'];
                $model->amount=$_POST['Salaries'][$i]['amount'];
                $model->date=date('Y-m-d');
                
                $checkD= Salaries::checkDublicate($user->id,$model->amount,$model->bankacc,$model->ssfacc);
                if ($checkD==null){
                    if ($model->save()){
                        $check++;
                    }else{
                        \Yii::$app->session->setFlash('error','Error in Salaries information of '. $user->fullName);
                        return $this->redirect(['create']);
                        }
                    }
                }
            }
            if ($check>0){
            \Yii::$app->session->setFlash('success',$check.' User salary modified');
            return $this->redirect(['index']);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,'users'=>$users
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,'users'=>$users,
            ]);
        }
    }

    /**
     * Updates an existing Salaries model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Salaries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Salaries model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Salaries the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Salaries::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
