<?php

namespace app\controllers;

use Yii;
use app\models\Invoices;
use app\models\InvoicesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Accounts;
use app\models\Invcontent;
use yii\data\ActiveDataProvider;

/**
 * InvoicesController implements the CRUD actions for Invoices model.
 */
class InvoicesController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invoices models.
     * @return mixed
     */
    public function actionIndex()
    {
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId != 0) $this->layout='cnf';
        
        $searchModel = new InvoicesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
    
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invoices model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Invoices model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Invoices();
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId==null){ $id=0; }else { $id=$fileId;  $this->layout='cnf'; } 

        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d');
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            $model->currency=Accounts::findOne($model->accId)->currency;
            $model->fileId=$id;
            
            if ($model->save()){
            return $this->redirect(['invcontent/create', 'id' => $model->id]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Invoices model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            if ($model->save()){
            return $this->redirect(['index',]);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Invoices model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Invoices model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invoices the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invoices::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    
    public function actionAccountsummary()
    {
        $model= new Invoices();
        $dataProvider=null;
        $from=null;
        $to=null;
        
        if (isset($_POST['Invoices'])) {
            $f=$_POST['Invoices']['from'];
            $t=$_POST['Invoices']['to'];
            $from=date('Y-m-d',strtotime($_POST['Invoices']['from']));
            $to=date('Y-m-d',strtotime($_POST['Invoices']['to']));
            $acc=$_POST['Invoices']['accId'];
            
            $query = Invoices::find()->where("date>='$from' and date <='$to' and accId='$acc'");
            $dataProvider = new ActiveDataProvider([
                'query' => $query,
                'pagination' => [
                    'pageSize' => 10,
                ],
                'sort' => [
                    'defaultOrder' => [
                        'date' => SORT_DESC,
                    ]
                ],
            ]);
            
            $from=$f;
            $to=$t;
        }
        
        return $this->render('accountsummary', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
    
    
    public function actionMovementsummary()
    {
        $model= new Invoices();
        $from=null;
        $to=null;
        $clienttype=null;
        
        if (isset($_POST['Invoices'])) {
            $from=$_POST['Invoices']['from'];
            $to=$_POST['Invoices']['to'];
            $clienttype=$_POST['Invoices']['clienttype'];
        }
        
        return $this->render('movementsummary', [
            'model' => $model,
            'clienttype' => $clienttype,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
}
