<?php

namespace app\controllers;

use Yii;
use app\models\Dispatchcontents;
use app\models\DispatchcontentsSearch;
use app\models\Wstore;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;

/**
 * DispatchcontentsController implements the CRUD actions for Dispatchcontents model.
 */
class DispatchcontentsController extends Controller
{
    public function init() {
        $this->layout = 'workshop';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Dispatchcontents models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DispatchcontentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Dispatchcontents model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Dispatchcontents model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Dispatchcontents();
        
        $query = Dispatchcontents::find();
        $query->andFilterWhere([
            'dispatchId' => $id,
        ]);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        if ($model->load(Yii::$app->request->post())) {
            $model->dispatchId=$id;
            $balance=Dispatchcontents::getStoreBalance($model->storeId);
            if($balance>=$model->quantity){
                if($model->save()){
                return $this->redirect(['create', 'id' => $id]);
                }
            }else {
                $model->quantity=$balance;
                if($model->save()){
                    \Yii::$app->session->setFlash('error','Spare added with less quantity');
                    $balance2=Dispatchcontents::getStoreBalance($model->storeId);
                    if ($balance2==0){
                        $Wstore=Wstore::findOne($model->storeId);
                        $Wstore->status=0;
                        $Wstore->save();
                    }
                    return $this->redirect(['create', 'id' => $id]);
                }
            }
        }

        return $this->render('create', [
            'model' => $model,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Dispatchcontents model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Dispatchcontents model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Dispatchcontents model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Dispatchcontents the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Dispatchcontents::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
