<?php

use app\models\Dispatchcontents;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Cars;
use app\models\Services;
use app\models\Wshopbills;
use app\models\Wstore;
use app\models\Bills;
use app\models\Billcontent;
use app\models\Wstoredispatch;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WstoreSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Workshop store';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wstore-index">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>


   <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name.'  ('.date('d-M',strtotime($model->date)).')'; },
            'contentOptions' => function($model, $key, $index, $column){
            if ($model->date!=date('Y-m-d')){
                return ['style' =>'background-color:#af3842; color:white;'];
            }else {
                return ['style' =>'background-color:#ffffff; color:000000;'];
            }
            }, 
            ],
            
            [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId.' - '.Cars::findOne($model->carId)->type->name; }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],  
            
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['rfqcontent/suppliedstore','id'=>$model->id],[
                    'class' => 'glyphicon glyphicon-ok',
                ]);
                },
                ],
        ],
    ]); ?>
    
</div>
