<?php

use app\models\Accounts;
use app\models\Billcontent;
use app\models\Billpayments;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Wshopbills;
use app\models\Bills;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WshopbillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Workshop requests';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wshopbills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

      <p align="right">
        <?= Html::a('New request', ['bills/createworkshop'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('New creditnote', ['bills/creditnote'], ['class' => 'btn btn-success']) ?>
      </p>
      
      <?php 
     
     /* $unpaid= Wshopbills::find()->all();
      $arr=array();
      if ($unpaid != null){
          foreach ($unpaid as $un){
              $bills= Bills::find()->where(['id'=>$un->billid])->all();
              
              if ($bills == null){
                  $arr[]=$un->id;
              }
          }
      }
      
      echo count($arr).'<br>';
      
      for ($i = 0; $i < count($arr); $i++) {
          echo $arr[$i].'<br>';
          $wbill= Wshopbills::findOne($arr[$i]);
          $wbill->delete();
      }  */
      
      ?>
      
<?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>
      
  <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
          [
                'attribute'=>'Status',
                'value'=>function ($model, $key, $index, $widget) {return $model->bill->paid==0?'Pending':'Paid'; },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->bill->paid==0){
                    return ['style' =>'background-color:#101CE0; color:white;'];
                }elseif ($model->bill->paid!=0){
                    return ['style' =>'background-color:#197777; color:white;'];
                }
                },
                ],
                
              [
                'attribute'=>'numbername',
                'value'=>function ($model, $key, $index, $widget) {return Bills::getBillNo(Bills::findOne($model->billid)->company,$model->billid); }
            ],

               [
                'attribute'=>'client',
                'value'=>function ($model, $key, $index, $widget) {return $model->bill->client->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->dueDate)); }
            ],
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->billid)).' '.Accounts::getCurrency($model->bill->currency); }
            ],
            
               
            [
                'attribute'=>'paidamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billpayments::getPaidByBill($model->billid)).' '.Accounts::getCurrency($model->bill->currency); }
            ],
            
            //'paid',
            //'company',
            //'currency',
  		
  		            
            		            
            [
                'class' => 'yii\grid\ActionColumn',
                'contentOptions' => ['style' => 'width:60px;'],
                'header'=>'Actions',
                'template' => '{view}',
                'buttons' => [
                    
                    //view button
                    'view' => function ($url, $model) {
                    
                    return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Update',['bills/update','id'=>$model->billid], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Download',['billcontent/printrequest','id'=>$model->billid], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Lpo',['billcontent/printlpo','id'=>$model->billid], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Record payment',['billpayments/create','id'=>$model->billid], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['bills/delete','id'=>$model->billid], ['class' => 'glyphicon','data' => [
                              'confirm' => 'Are you sure you want to delete this item?',
                              'method' => 'post',
                          ]]).' </li>
                          </ul>
                        </div>';
                    
                    
                    },
                    ],
                    
                    ],
        ],
    ]); ?>
</div>