<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Cardrivers;
use app\models\Cars;
use app\models\Uzers;
use app\models\Leaves;

/* @var $this yii\web\View */
/* @var $model app\models\Uzers */

$this->title ='User profile';
$this->params['breadcrumbs'][] = ['label' => 'Users', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="uzers-view">

    <h3><?= Html::encode($this->title) ?></h3>

<div class="vd_content-section">

<div class="row">

<div class="col-sm-3">
<div class="profile-body">
<h3>About</h3>

<table class='table table-striped table-hover'>
<tr><th>Firstname</th><td><?php echo $model->firstname; ?></td></tr>
<tr><th>Secondname</th><td><?php echo $model->secondname; ?></td></tr>
<tr><th>Lastname</th><td><?php echo $model->lastname; ?></td></tr>
<tr><th style="width:60%;">Address</th><td><?php echo $model->address; ?></td></tr>
<tr><th>Mobile Phone</th><td><?php echo $model->mobilephone; ?></td></tr>
<tr><th>Age</th><td><?php echo Uzers::getAgeByBdate($model->birthdate); ?></td></tr>
</table>

</div>

</div>

<div class="col-sm-9">
<div class="content-list">
<h3>Activities</h3>
<ul class="list-wrapper">
<li><b>User status: </b><?php echo $model->status==1?'Active':'Dormant'; ?></li>
<li><b>Driving: </b>
<?php 
$cars= Cardrivers::find()->where(['userId'=>$model->id, 'status'=>1])->all();
$campcars=Cars::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();
if ($cars != null){
    if (count($campcars)==count($cars)){
        echo 'All';
    }else{
        foreach ($cars as $car){
            echo $car->carId.' | ';
        } 
    }
}else echo 'Non';


//echo 'Kampuni '. count($campcars). '<br>';
//echo 'Derewa wa '. count($cars);
?>
 <?= Html::a(' Set ', ['/cardrivers/setdrivercars','id'=>$model->id], ['class' => 'pull-right']) ?> 
 <?= Html::a(' Unset | ', ['/cardrivers/unsetdrivercars','id'=>$model->id], ['class' => 'pull-right']) ?>
</li>

</ul>
</div>
</div>


<div class="col-sm-9">
<div class="content-list">
    <h3>Leaves for <?php echo date('Y'); ?></h3>
    <p align="right"> <?= Html::a('New leave', ['/leaves/create','id'=>$model->id]) ?> </p>
    <ul class="list-wrapper">
        
         <?php  
            $cnt=1;
            $leaves = Leaves::find()->where(['userId'=>$model->id])->orderBy(['startdate'=>SORT_DESC])->all();
                if($leaves != null){
                    foreach($leaves as $leave){      
         ?>
        
    <li><b>From: </b><?php echo date('d-M-Y',strtotime($leave->startdate)); ?> <b>To: </b><?php echo date('d-M-Y',strtotime($leave->enddate)); ?> <b>Duration: </b> <?php echo Uzers::getdaysdifference($leave->startdate,$leave->enddate); ?></li>
    <?php   
                $cnt++;
                if ($cnt == 5) break;
                    }
                }
    
    ?>
   
    </ul>
    </div>
    </div>

</div>

</div>

</div>
