<?php

use app\models\Cardrivers;
use app\models\Trafficoffences;
use kartik\date\DatePicker;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Trafficoffences */

$this->title ='Offence';
$this->params['breadcrumbs'][] = ['label' => 'Trafficoffences', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'offence';
\yii\web\YiiAsset::register($this);
?>

<h3>Offence details / Payment records</h3>

<p>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>


<div class="trafficoffences-form">

     <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table class="table table-striped table-bordered table-hover">

<tr><td><b>Responsible part</b></td><td><?php echo Trafficoffences::getResponsible($model->responsible); ?></td></tr>
<tr><td><b>Offence date</b></td><td><?php echo date('d-m-Y',strtotime($model->offencedate)); ?></td></tr>
<tr><td><b>Car</b></td><td><?php echo $model->carId; ?></td></tr>
<tr><td><b>Driver</b></td><td><?php echo Cardrivers::findOne($model->driverId)->user->fullName; ?></td></tr>
<tr><td><b>Amount</b></td><td><?php echo Trafficoffences::calculateCost($model->offencedate,$model->paiddate,$model->Amount); ?></td></tr>
<tr><td><b>Reference</b></td><td><?php echo $model->ref; ?></td></tr>
<tr><td><b>Officer</b></td><td><?php echo $model->officer; ?></td></tr>
<tr><td><b>Reason</b></td><td><?php echo $model->reason; ?></td></tr>
<tr><td><b>Paid date</b></td><td><?php

echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'paiddate',
    'options' => ['placeholder' => 'paid date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);


?>
</td></tr>

  <tr>
  <td></td>
  <td>  
  <div class="form-group">
    <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
 </td>
  </tr>

</table>
 <?php ActiveForm::end(); ?>
</div>
