<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Trafficoffences;
use app\models\Offencepayments;
use app\models\Uzers;
use app\models\Cardrivers;
use app\models\Movetype;
use Faker\Provider\cs_CZ\DateTime;

/* @var $this yii\web\View */
/* @var $searchModel app\models\TrafficoffencesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Active drivers depts';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="trafficoffences-index">

     <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::button('New depts',['value'=>\yii\helpers\Url::toRoute('createfuel'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
          <?= Html::a('Caribrate offences', ['analyseoffences'], ['class' => 'btn btn-success']) ?>
        
    </p>
  
        
<?php 

    Modal::begin([
        'options'=>[
            'tabindex' => false,
        ],
        'header'=>'',
        'id'=>'modal',
        'size'=>'modal-lg',
    ]);
    
    echo '<div id="modalContent"></div>';
    
    Modal::end();
    
    ?>
   

   <table class="table table-striped table-bordered table-hover">
       <tr>
           <th>#</th>
           <th>Driver</th>
           <th>Car</th>
           <th>Reason</th>
           <th>Amount</th>
           <th>MonthPaid</th>
           <th>TotalPaid</th>
           <th>Due date</th>
           <th></th>
            <th></th>
            <th></th>
       </tr>
    
       <?php 
       if($data != null){
           $cnt=1; 
           $from=date('Y-m',strtotime('-1 months')).'-01';
           $to=date('Y-m',strtotime('-1 months')).'-30';
           foreach($data as $dt){
               ?>
            <tr>
                <td><?php echo $cnt; ?></td>
               <td><?php echo Cardrivers::findOne($dt->driverId)->user->firstname.' '.Cardrivers::findOne($dt->driverId)->user->lastname.' ('. number_format(Movetype::driverIncentiveByTime($dt->driverId,$from,$to)['incentive']).')'; ?></td>
               <td><?php echo $dt->carId; ?></td>
               <td><?php echo $dt->reason; ?></td>
               <td><?php echo number_format($dt->Amount); ?></td>
               <td><?php echo number_format(Offencepayments::paymentbyoffencethismonth($dt->id)); ?></td>
               <td><?php echo number_format(Offencepayments::paymentbyoffence($dt->id)); ?></td>
               <td><?php echo date('d-m-y',strtotime($dt->paiddate)); ?></td>
               <td> <?= Html::a(' ',['offencepayments/view','id'=>$dt->id],['class' => 'glyphicon glyphicon-eye-open']) ?></td>
                <td> <?= Html::a(' ',['update','id'=>$dt->id],['class' => 'glyphicon glyphicon-pencil']) ?></td>
                <td> <?= Html::a(' ',['bringbackward','id'=>$dt->id],['class' => 'glyphicon glyphicon-step-backward']) ?></td>
            </tr>
               <?php
               $cnt++;
           }
       
       }
       ?>
  
   </table> 
   
   </div>
