<?php

use app\models\Cardrivers;
use app\models\Cars;
use app\models\Cartype;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use keygenqt\autocompleteAjax\AutocompleteAjax;
use yii\jui\AutoComplete;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $model app\models\Trafficoffences */
/* @var $form yii\widgets\ActiveForm */
?>

<?php 
$truck = ArrayHelper:: map (Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all() , 'plateno' , 'plateno');
$driver = ArrayHelper:: map (Cardrivers::find()->where(['status'=>1])-> all() , 'id' , function($model, $defaultValue){ return $model['user']['firstname'].' '.$model['user']['lastname'].' ('.$model['user']['licence'].')'; });

?>

<div class="trafficoffences-form">

     <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table width="100%">
<tr>

 <td> <?= $form->field($model, 'type')->dropdownList([
        2 => 'Fuel dept', 
        3 => 'Workshop dept',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

<td>
   <?php 
   

echo $form->field($model, 'carId')->widget(Select2::classname(), [
    'data' => $truck,
    'language' => 'en',
    'options' => ['placeholder' => 'Select truck...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);

   
?>
</td>


<td>
   <?php 

echo $form->field($model, 'driverId')->widget(Select2::classname(), [
    'data' => $driver,
    'language' => 'en',
    'options' => ['placeholder' => 'Driver...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);

?>

</td>

</tr>

</table>

<table width="100%">

<tr>

<td> <?= $form->field($model, 'Amount')->textInput() ?> </td>

<td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'offencedate',
    'options' => ['placeholder' => 'Offence date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>


<td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'paiddate',
    'options' => ['placeholder' => 'Final date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>

<td> <?= $form->field($model, 'span')->textInput() ?> </td>

</table>

  <table width="50%">
  <tr>
  <td> <?= $form->field($model, 'reason')->textArea(['maxlength' => true]) ?></td>
  </tr>
  
  <tr>
  <td>  
  <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
 </td>
  </tr>
  
  </table>
    <?php ActiveForm::end(); ?>

</div>
