<?php

use app\models\Tirestore;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Tireallocation */

$this->title = 'Tire allocation for: '.$truckno;
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tireallocation-create">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>

    
       <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            [
                'attribute'=>'reference',
                'value'=>function ($model, $key, $index, $widget) {return $model->store->regnumber; }
            ],
            [
                'attribute'=>'brand',
                'value'=>function ($model, $key, $index, $widget) {return $model->store->brandname; }
            ],
            [
                'attribute'=>'type',
                'value'=>function ($model, $key, $index, $widget) {return Tirestore::getTireType($model->store->type); }
            ],
            [
                'attribute'=>'size',
                'value'=>function ($model, $key, $index, $widget) {return $model->store->size; }
            ],
            
            'date',
            
            [
                'attribute'=>'status',
                'value'=>function ($model, $key, $index, $widget)  {return Tirestore::getTireCategory($model->store->category); }
            ],
           
            [
                'label'=>'Replace',
                'format' => 'raw',
                'value'=>function ($data) {
                return Html::a('Replaced',['tireallocation/replace','id'=>$data->id]);
                },
                ],
                             
                [
                    'label'=>'Edit',
                    'format' => 'raw',
                    'value'=>function ($data) {
                    return Html::a('Edit',['tireallocation/update','id'=>$data->id]);
                    },
                    ],
        ],
    ]); ?>
    
    

    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
