<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\TrailersSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Admin statistics';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="trailers-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-M-Y',strtotime($model->date)); }
            ],
            'truckId',
            [
                'attribute'=>'driver',
                'value'=>function ($model, $key, $index, $widget) {return $model->driver0->user->fullName; }
            ],
            [
                'attribute'=>'movetype',
                'value'=>function ($model, $key, $index, $widget) {return  $model->movetype0->name; }
            ],
            
            [
                'attribute'=>'size',
                'value'=>function ($model, $key, $index, $widget) {return  $model->size.'0'; }
            ],
            'quantity',

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}{delete}',
            ],
        ],
    ]); ?>
</div>
