<?php

use app\models\Cars;
use app\models\Cartype;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Statistics;
use app\models\Accounts;

/* @var $this yii\web\View */
/* @var $searchModel app\models\StatisticsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = "Statistics which was recorded today";
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="statistics-index">

  
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

     <p align="right">
        <?= Html::a('New statistics', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    
      <h3><?= Html::encode($this->title) ?></h3>
      
      
      <?= GridView::widget([
          'dataProvider' => $dataProvider,
          'filterModel' => $searchModel,
          'columns' => [
              ['class' => 'yii\grid\SerialColumn'],
              
              [
                  'attribute'=>'movetype',
                  'value'=>function ($model, $key, $index, $widget) {return $model->movetype==1?"Full":"Empty"; }
              ],
              
              [
                  'attribute'=>'date',
                  'value'=>function ($model, $key, $index, $widget) {return $model->truckId; }
              ],
              
              [
                  'attribute'=>'quantity',
                  'value'=>function ($model, $key, $index, $widget) {return $model->quantity; }
              ],
              
              [
                  'attribute'=>'date',
                  'value'=>function ($model, $key, $index, $widget) {return $model->date; }
              ],
              
              
              [
                  'class' => 'yii\grid\ActionColumn',
                  'contentOptions' => ['style' => 'width:60px;'],
                  'header'=>'Actions',
                  'template' => '{view}',
                  'buttons' => [
                      
                      //view button
                      'view' => function ($url, $model) {
                      
                      return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Update',['statistics/update','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['statistics/delete','id'=>$model->id], ['class' => 'glyphicon','data' => [
                              'confirm' => 'Are you sure you want to delete this item?',
                              'method' => 'post',
                          ]]).' </li>
                          </ul>
                        </div>';
                          
                          
                      },
                      ],
                      
                      ],
                      
                      ],
                      ]); ?>
     

</div>
