<?php

use app\models\Servicecost;
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Accounts;
use app\models\Uzers;
use app\models\Billcontent;
use app\models\Cars;
use app\models\Bills;

/* @var $this yii\web\View */
/* @var $model app\models\Services */

$this->title ='Profile';
$this->params['breadcrumbs'][] = ['label' => 'Services', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="services-view">

    <h3><?= Html::encode($this->title) ?></h3>

    <p align="right">
        <?= Html::a('Deactivate', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to deactivate this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'description',
            [
                'attribute'=>'status',
                'value'=>Uzers::getStatus($model->status),
            ],
            [
                'attribute'=>'date',
                'value'=>date('d-m-Y',strtotime($model->date)),
            ],
            [
                'attribute'=>'purchasecost',
                'value'=>number_format(Servicecost::getServiceCost($model->id)->purchasecost,2),
                ],
            
            [
                'attribute'=>'saleprice',
                'value'=>number_format(Servicecost::getServiceCost($model->id)->saleamount,2),
                ],
        ],
    ]) ?>

</div>

<h3>How is requested</h3>
<?php 

$contents=Billcontent::find()->where(['serviceId'=>$model->id])->orderBy(['id'=>SORT_DESC])->all();
$cnt=1;
if ($contents != null){
    ?>   
    
<table class="table table-striped table-bordered table-hover"><tr><th style ="border-bottom:1px solid black;">#</th><th style ="border-bottom:1px solid black;">Request price</th><th style ="border-bottom:1px solid black;">Bill</th><th style ="border-bottom:1px solid black;">Truck</th></tr>
 
    
    <?php  foreach ($contents as $content){  ?>
  
  <tr>
  <td><?php echo  $cnt; ?></td>
  <td><?php echo number_format($content->amount);  ?></td>
 <td><?php echo Bills::getBillNo(Bills::findOne($content->billId)->company,$content->billId).' - '.Bills::findOne($content->billId)->client->name;  ?></td>
 <td><?php echo $content->carId != null?$content->carId.' - '.Cars::findOne($content->carId)->type->name:' '; ?></td>
  </tr>
        
        <?php
        $cnt++;
        
        if ($cnt==16) break;
    }
}

?>

</table>
