<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Servicecost;
use app\models\Accounts;
use app\models\Services;
use app\models\Billcontent;

/* @var $this yii\web\View */
/* @var $searchModel app\models\ServicesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All Services/Products';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="services-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
     <?= Html::a('New service/product', ['create'], ['class' => 'btn btn-success']) ?>
      </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'name',
                'value'=>function ($model, $key, $index, $widget) {
                return $model->name.'-'.Accounts::getCurrency($model->currency);
                },
                ],
                
            [
                'attribute'=>'purchasecost',
                'value'=>function ($model, $key, $index, $widget) {
                return Servicecost::getServiceCost($model->id)==null?0:number_format(Servicecost::getServiceCost($model->id)->purchasecost);
                },
                ],
                
                [
                    'attribute'=>'saleprice',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Servicecost::getServiceCost($model->id)==null?0:number_format(Servicecost::getServiceCost($model->id)->saleamount);
                    },
                    ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}{view}',
            ],
        ],
    ]); ?>
</div>


<?php 
/*
$svs= Services::find()->all();

if ($svs != null){
    foreach ($svs as $sv){
        $blcs= Billcontent::find()->where(['serviceId'=>$sv->id])->orderBy(['id'=>SORT_DESC])->all();
        if ($blcs != null){
            foreach ($blcs as $blc){
                $nw= Servicecost::find()->where(['serviceId'=>$sv->id])->one();
                $nw->purchasecost=$blc->amount;
                $nw->save();
            }
        }
    }
}
*/
?>
