<?php

use app\models\Accounts;
use app\models\Bills;
use app\models\Rfq;
use app\models\Services;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Rfqcontent;
use app\models\Cars;

/* @var $this yii\web\View */
/* @var $model app\models\Rfqcontent */

$this->title = 'Request for quotation form';
$this->params['breadcrumbs'][] = ['label' => 'Rfqcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rfqcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
 <p align="left">
        <?= Html::a('All', ['rfqcontent/printrequestforquote','sel'=>0]) ?>
   &nbsp;  &nbsp; | &nbsp;  &nbsp;
        <?= Html::a('Today', ['rfqcontent/printrequestforquote','sel'=>1]) ?>
     </p>
           <p align="right">
        <?= Html::button('New service/product',['value'=>\yii\helpers\Url::toRoute('services/createworkshop'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

   <?= $this->render('_form', [
        'models' => $models,
    ]) ?>
    

<b>Billed on: </b><?php echo date('d-m-Y');?> </br><b>Due date: </b><?php echo date('d-m-Y',strtotime("+1 days"));?>
  <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name.'  ('.date('d-M',strtotime($model->date)).')'; },
                'contentOptions' => function($model, $key, $index, $column){
	            if ($model->date!=date('Y-m-d')){
	                return ['style' =>'background-color:#af3842; color:white;'];
	            }else {
	                return ['style' =>'background-color:#ffffff; color:000000;'];
	            }
	            }, 
            ],
            
           [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId.' - '.Cars::findOne($model->carId)->type->name; }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],  
            
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['rfqcontent/supplied','id'=>$model->id],[
                    'class' => 'glyphicon glyphicon-ok',
                ]);
                },
                ],
                
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
             [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['rfqcontent/printrequestforquotebycar','truckid'=>$model->carId],[
                    'class' => 'glyphicon glyphicon-sort-by-alphabet',
                ]);
                },
                ],
        ],
    ]); ?>

 

</div>