<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Rfqcontent;
use app\models\Rfq;

/* @var $this yii\web\View */
/* @var $searchModel app\models\RfqSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All request for quotations';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rfq-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New Rfq', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
 

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            'id',
            [
                'attribute'=>'billby',
                'value'=>function ($model, $key, $index, $widget) {return $model->billby0->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->dueDate)); }
            ],
           
            //'paid',
            //'company',
            //'currency',
            
            
            
            [
                'class' => 'yii\grid\ActionColumn',
                'contentOptions' => ['style' => 'width:60px;'],
                'header'=>'Actions',
                'template' => '{view}',
                'buttons' => [
                    
                    //view button
                    'view' => function ($url, $model) {
                    
                    return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Edit content',['rfqcontent/create','id'=>$model->id],['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Download',['rfqcontent/printrequest','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Update',['rfqcontent/update','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['rfqcontent/delete','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          </ul>
                        </div>';
                    
                    
                    },
                    ],
                    
                    ],
        ],
    ]); ?>

</div>
