<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Cfile;
use app\models\Packages;

/* @var $this yii\web\View */
/* @var $searchModel app\models\PackagesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Bl #: '.Cfile::findOne(\Yii::$app->session->get('fileId'))->blnumber.' packages';
$this->params['breadcrumbs'][] ='packages';
?>
<div class="packages-index">

    <h3><?= Html::encode($this->title) ?>  </h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
      <p align="right">
        <?= Html::button('New package',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
        
       <?= Html::a('', ['packages/printpackages','id'=>\Yii::$app->session->get('fileId')], ['class' => 'glyphicon glyphicon-download-alt pull-left']) ?>
    </p>
    
       <p align="left">
       
    </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'containerno',
            [
                'attribute'=>'type',
                'value'=>function ($model, $key, $index, $widget) {return Packages::getType($model->type); }
            
            ],
            'volumekg',
            'barels',
            //'onn',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
