<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cardrivers;

/* @var $this yii\web\View */
/* @var $searchModel app\models\OffencepaymentsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Offencepayments';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="offencepayments-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Offencepayments', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
             [
                'attribute'=>'offenceid',
                'value'=>function ($model, $key, $index, $widget) {return Cardrivers::findOne($model->offence->driverId)->user->fullName; }
            ],
             [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
             [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount); }
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
