<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Accounts;
use app\models\Movetype;

/* @var $this yii\web\View */
/* @var $searchModel app\models\MovetypeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All types of movement';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="movetype-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New type', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    
    <?php /*
    $typemove= Movetype::find()->all();
    $cnt=0;
    if($typemove != null){
        foreach($typemove as $move){
            if($move->incentive == 12000){
              
                $cnt++;
            }
        }
    }
    echo 'moves which are 12000: '. $cnt;
    */
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'name',
                'value'=>function ($model, $key, $index, $widget) {return $model->name.' ('.Movetype::getTripType($model->triptype).')-'.Accounts::getCurrency($model->currency); }
            ],
            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
