<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Movetype;
use Symfony\Component\Finder\Comparator\DateComparator;
use app\models\Movements;

/* @var $this yii\web\View */
/* @var $searchModel app\models\MovementsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All movements';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="movements-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New movement', ['create'], ['class' => 'btn btn-success']) ?>
    </p>


    
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'layout' => '{items}{pager}',
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'containerno',
            
            [
                'attribute'=>'size',
                'value'=>function ($model, $key, $index, $widget) {return  Movetype::getContainerSize($model->size); }
            ],
            
            [
                'attribute'=>'truckId',
                'value'=>function ($model, $key, $index, $widget) {return $model->truck->plateno; }
            ],
            
            
            [
                'attribute'=>'interchangedate',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->interchangedate)); },
                ],
                
                [
                    'attribute'=>'registereddate',
                    'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->registereddate)); },
                    ],
            
            [
                'attribute'=>'movetypeId',
                'value'=>function ($model, $key, $index, $widget) {return $model->movetype->name; },
            ],
           
            [
                'attribute'=>'driverId',
                'value'=>function ($model, $key, $index, $widget) {return $model->driver->user->firstname.' '.$model->driver->user->lastname;},
            ],
            
            [
                'attribute'=>'byy',
                'value'=>function ($model, $key, $index, $widget) {return $model->byy0->firstname;},
                ],
           
              [
                    'class' => 'yii\grid\ActionColumn',
                    'contentOptions' => ['style' => 'width:60px;'],
                    'header'=>'Actions',
                    'template' => '{view}',
                    'buttons' => [
                        
                        //view button
                        'view' => function ($url, $model) {
                        
                        return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                         <li>'.Html::a('Update',['movements/update','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Move',['movements/move','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                              
                          </ul>
                        </div>';
                          
                          
                        },
                        ],
                        
                        ],
        ],
    ]); ?>
</div>

<?php /*
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();
*/
?>