<?php

use app\models\Clients;
use app\models\Movements;
use app\models\Movetype;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Movements */

$this->title = 'Client movements summary from:'.$from.' to:'.$to;
$this->params['breadcrumbs'][] = ['label' => 'Movements', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="movements-create">

    <h3><?= Html::encode($this->title) ?></h3>

    <?= $this->render('_dateform', [
        'model' => $model,
    ]) ?>

</div>

<table class="table table-striped table-bordered table-hover">
                              <thead>
                                 <tr>
                                 <th>#</th>
                                    <th>Client</th>
                                     <th>20ft</th>
                                    <th>40ft</th>
                                    <th>Others</th>
                                    <th>Total</th>
                                 </tr>
                              </thead>
                              <tbody>
                              
                              <?php
                              if ($from != null and $to != null){
                                $clients= Clients::find()->all();
                                $f=date('Y-m-d',strtotime($from));
                                $t=date('Y-m-d',strtotime($to));
                                $cnt=1;
                                
                                if ($clients != null){
                                    foreach ($clients as $clie){
                                        
                                        $twft= Movements::clientAmountOfLoadBySizeTime($clie->id,$f,$t,2);
                                        $ftft= Movements::clientAmountOfLoadBySizeTime($clie->id,$f,$t,4);
                                        $others= Movements::clientAmountOfLoadBySizeTime($clie->id,$f,$t,0);
                                        $total=$twft+$ftft+$others;
                                        
                                        if ($total>0){
                                        ?>
                                        <tr>
                                        <td><?php echo $cnt; ?></td>
                                         <td><?php echo $clie->name; ?></td>
                                          <td><?php echo $twft; ?></td>
                                           <td><?php echo $ftft; ?></td>
                                            <td><?php echo $others; ?></td>
                                             <td><?php echo $total; ?></td>
                                            </tr>
                                        <?php
                                        $cnt++;
                                        } } } }
                              ?>
                                    </tbody></table>
                                    
