<?php

use app\models\Cardrivers;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Symfony\Component\BrowserKit\Client;
use app\models\Cartype;
use app\models\Clients;
use app\models\Trailers;
use app\models\Movetype;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use app\models\Cars;

/* @var $this yii\web\View */
/* @var $model app\models\Movements */
/* @var $form yii\widgets\ActiveForm */
?>

<?php  	

$driver = ArrayHelper:: map (Cardrivers::find()->where(['status'=>1])-> all() , 'id' , function($model, $defaultValue){ return $model['user']['fullName']; }); 
$client = ArrayHelper:: map (Clients::find()->where(['type'=>1])->all() , 'id' , 'name');
$truck = ArrayHelper:: map (Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all() , 'plateno' , 'plateno');
$moves = ArrayHelper:: map (Movetype::find()-> all() , 'id' , function($model, $defaultValue){ return $model['name'].' ('.Movetype::getTripType($model['triptype']).')'; });
$shippingline = ArrayHelper:: map (Clients::find()->where(['type'=>2])->all() , 'id' , 'name');

?>


<div class="movements-form">

         <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table width="100%">

<tr>
    
    <td>
     <?php 

echo $form->field($model, 'clientId')->widget(Select2::classname(), [
    'data' => $client,
    'language' => 'en',
    'options' => ['placeholder' => 'Select a client...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?></td>

    
<td><?= $form->field($model, 'containerno')->textInput(['maxlength' => true]) ?></td>

<td>
   <?php 

echo $form->field($model, 'shippingline')->widget(Select2::classname(), [
    'data' => $shippingline,
    'language' => 'en',
    'options' => ['placeholder' => 'Select shippingline...', 'style'=>'width:20px;',],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);

?>
</td>
    

<td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'interchangedate',
    'options' => ['placeholder' => 'Interchange date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>


     <td> <?= $form->field($model, 'size')->dropdownList([
        2 => '20ft', 
        4 => '40ft',
         0=>'Nill',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

</tr>

<tr>
<td>    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div> </td><td></td><td></td><td></td><td></td></tr>
    
    </table>

    <?php ActiveForm::end(); ?>

</div>
